/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.tables;

import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.tables.VWSubmapUsageItem;
import filenet.vw.toolkit.utils.VWStepUtils;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.VWQuickSort;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public final class VWSubmapUsageTableModel
extends AbstractTableModel {
    private static final int NUM_COLUMNS = 2;
    public static final int COL_CALLERMAPNAME = 0;
    public static final int COL_STEPNAME = 1;
    private VWAuthPropertyData m_authPropertyData = null;
    private String m_mapName = null;
    private Vector m_rowData = null;

    public VWSubmapUsageTableModel(VWAuthPropertyData authPropertyData, String mapName) {
        try {
            this.m_authPropertyData = authPropertyData;
            this.m_rowData = new Vector();
            this.m_mapName = mapName;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void copyItem(int nRowIndex) {
    }

    public void deleteItem(int nRowIndex) {
    }

    public void reinitialize() {
        try {
            this.m_rowData = new Vector();
            String[] callerMaps = this.getCallerMaps(this.m_mapName);
            if (callerMaps != null) {
                int mapDefCount;
                VWMapDefinition[] mapDefs;
                VWWorkflowDefinition wfDef;
                int callerMapCount = callerMaps.length;
                if (callerMapCount > 0 && this.m_authPropertyData != null && (wfDef = this.m_authPropertyData.getWorkflowDefinition()) != null && (mapDefs = this.m_authPropertyData.getMapCache().getMapDefinitions()) != null && (mapDefCount = mapDefs.length) != 0) {
                    for (int i = 0; i < callerMapCount; ++i) {
                        for (int j = 0; j < mapDefCount; ++j) {
                            int mapNodeCount;
                            VWMapDefinition mapDef = mapDefs[j];
                            if (VWStringUtils.compare(callerMaps[i], mapDef.getName()) != 0) continue;
                            j = mapDefCount;
                            VWMapNode[] mapNodes = mapDef.getSteps();
                            if (mapNodes == null || (mapNodeCount = mapNodes.length) <= 0) continue;
                            block7: for (int k = 0; k < mapNodeCount; ++k) {
                                VWMapNode mapNode = mapNodes[k];
                                int stepType = VWStepUtils.getStepType(mapNode);
                                switch (stepType) {
                                    case 9: 
                                    case 10: 
                                    case 11: 
                                    case 12: {
                                        int calledMapCount;
                                        String[] calledMaps = VWStepUtils.getCalledMapNames(mapNode);
                                        if (calledMaps == null || (calledMapCount = calledMaps.length) <= 0) continue block7;
                                        for (int l = 0; l < calledMapCount; ++l) {
                                            if (VWStringUtils.compare(calledMaps[l], this.m_mapName) != 0) continue;
                                            String mapName = mapDef.getName();
                                            if (VWStringUtils.compare(mapName, "Workflow") == 0) {
                                                mapName = VWResource.s_mainMapLabel.toString(mapName);
                                            }
                                            VWSubmapUsageItem item = new VWSubmapUsageItem(mapName, mapNode.getName());
                                            this.m_rowData.addElement(item);
                                        }
                                        continue block7;
                                    }
                                }
                            }
                        }
                    }
                }
                this.fireTableDataChanged();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public Class getColumnClass(int nColumnIndex) {
        Class<String> resultClass = null;
        switch (nColumnIndex) {
            case 0: {
                resultClass = String.class;
                break;
            }
            case 1: {
                resultClass = String.class;
            }
        }
        return resultClass;
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int nColumnIndex) {
        String resultString = null;
        switch (nColumnIndex) {
            case 0: {
                resultString = VWResource.s_callerMap;
                break;
            }
            case 1: {
                resultString = VWResource.s_step;
            }
        }
        return resultString;
    }

    public int getRowCount() {
        if (this.m_rowData != null) {
            return this.m_rowData.size() + 1;
        }
        return 0;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        VWSubmapUsageItem submapUsageItem = null;
        String object = null;
        try {
            submapUsageItem = this.getItemAt(nRowIndex);
            switch (nColumnIndex) {
                case 0: {
                    if (submapUsageItem != null) {
                        object = submapUsageItem.getCallerMapName();
                        break;
                    }
                    object = new String();
                    break;
                }
                case 1: {
                    object = submapUsageItem != null ? submapUsageItem.getStepName() : new String();
                }
            }
            return object;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        return false;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
    }

    private VWSubmapUsageItem getItemAt(int nRowIndex) {
        VWSubmapUsageItem item = null;
        if (this.m_rowData == null || nRowIndex < 0 || nRowIndex > this.m_rowData.size()) {
            return null;
        }
        if (nRowIndex < this.m_rowData.size()) {
            item = (VWSubmapUsageItem)this.m_rowData.elementAt(nRowIndex);
        }
        return item;
    }

    private String[] getCallerMaps(String currentMapName) {
        Vector<String> mapNames = null;
        Object[] callerMapNames = null;
        try {
            int mapDefsSize;
            VWMapDefinition[] mapDefs;
            VWWorkflowDefinition wfDefinition;
            if (this.m_authPropertyData != null && (wfDefinition = this.m_authPropertyData.getWorkflowDefinition()) != null && (mapDefs = this.m_authPropertyData.getMapCache().getMapDefinitions()) != null && (mapDefsSize = mapDefs.length) > 0) {
                mapNames = new Vector<String>();
                for (int i = 0; i < mapDefsSize; ++i) {
                    int mapNodesSize;
                    VWMapNode[] mapNodes = mapDefs[i].getSteps();
                    if (mapNodes == null || (mapNodesSize = mapNodes.length) <= 0) continue;
                    for (int j = 0; j < mapNodesSize; ++j) {
                        int callerMapNamesSize;
                        int stepType = VWStepUtils.getStepType(mapNodes[j]);
                        if (stepType != 9 && stepType != 10 && stepType != 11 && stepType != 12 || (callerMapNames = VWStepUtils.getCalledMapNames(mapNodes[j])) == null || (callerMapNamesSize = callerMapNames.length) <= 0) continue;
                        for (int k = 0; k < callerMapNamesSize; ++k) {
                            if (VWStringUtils.compare((String)callerMapNames[k], currentMapName) != 0) continue;
                            boolean found = false;
                            int size = mapNames.size();
                            if (size > 0) {
                                String name = mapDefs[i].getName();
                                for (int l = 0; l < size; ++l) {
                                    if (VWStringUtils.compare((String)mapNames.elementAt(l), name) != 0) continue;
                                    found = true;
                                    break;
                                }
                                if (found) continue;
                                mapNames.addElement(name);
                                continue;
                            }
                            mapNames.addElement(mapDefs[i].getName());
                        }
                    }
                }
                int size = mapNames.size();
                if (size > 0) {
                    callerMapNames = new String[mapNames.size()];
                    mapNames.copyInto(callerMapNames);
                    if (size > 1) {
                        for (int i = 0; i < size; ++i) {
                            if (VWStringUtils.compare((String)callerMapNames[i], "Workflow") != 0) continue;
                            if (i != 0) {
                                callerMapNames[i] = callerMapNames[0];
                            }
                            callerMapNames[0] = "Workflow";
                            break;
                        }
                    }
                    VWQuickSort quicksort = new VWQuickSort(callerMapNames, 0);
                    quicksort.sort(1, callerMapNames.length - 1);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return callerMapNames;
    }
}

